#ifndef _gst_utils_h__
#define _gst_utils_h__

#include "GSTenums.h"
#include "buildspec.h"
#include "config.h"
#include "exceptions/GSTRuntimeException.h"
#include <fstream>
#include <string>

namespace GST
{
namespace Utils
{

template<class T_ptr>
bool checkPointer(T_ptr pointer,
				  const std::string &optMessage = std::string(),
				  bool noThrow = false)
{
	if(!pointer)
	{
		std::string msg;
		if(optMessage.empty())
		{
			msg = "invalid pointer";
		}
		else
		{
			msg = optMessage;
		}

		if(noThrow)
		{
			return false;
		}
		else
		{
			throw exceptions::GSTRuntimeException(__METHOD_NAME__, msg);
		}
	}

	return true;
}

GST_API_EXPORT void fileToString(std::string &result,
								 const std::string &file,
								 bool binary = false);

struct GST_API_EXPORT EscapeOption
{
	enum Type
	{
		Windows,
		Posix
	};

	EscapeOption()
		: maxChars(EscapeOption::unlimited())
		, type(EscapeOption::Windows)
	{
	}
	EscapeOption(EscapeOption::Type type, std::size_t maxChars)
		: maxChars(maxChars)
		, type(type)
	{
	}
	static std::size_t unlimited()
	{
		return 0;
	}

	std::size_t maxChars;
	Type type;
};

GST_API_EXPORT void escapeFilename(std::string &fileName,
								   const EscapeOption &options
								   = EscapeOption());
GST_API_EXPORT std::string escapeFilenameCopy(const std::string &fileName,
											  const EscapeOption &options
											  = EscapeOption());

const std::string SERIAL_TYPE_NAME = "serial";
const std::string BOOL_TYPE_NAME = "boolean";
const std::string INT_TYPE_NAME = "int32";
const std::string LONG_TYPE_NAME = "integer";
const std::string FLOAT_TYPE_NAME = "float 4 bytes";
const std::string DOUBLE_TYPE_NAME = "float 8 bytes";
const std::string TEXT_TYPE_NAME = "text";
const std::string FLOAT4BYTESVEC_TYPE_NAME = "float 4 bytes vector";
const std::string COLOR_RGBA_TYPE_NAME = "color rgba";
const std::string TIMESTAMP_TYPE_NAME = "timestamp";

GST_API_EXPORT std::string PropertyType2Str(const GST::DataType &type);
GST_API_EXPORT GST::DataType Str2PropertyType(const std::string &type);

} // namespace Utils
} // namespace GST

#endif // _utils_h__
